/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.utils;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonElement;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.mixin.ConfigurableRegistryLookupAccessor;
import io.wispforest.accessories.utils.EndecDataLoader;
import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.network.ClientAccess;
import io.wispforest.owo.network.OwoNetChannel;
import io.wispforest.owo.serialization.RegistriesAttribute;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_5350;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ManagedEndecDataLoader<T>
extends EndecDataLoader<T> {
    private static final Map<class_2960, ManagedEndecDataLoader<?>> ALL_DATA_LOADERS = new LinkedHashMap();
    private final BiMap<class_2960, T> server = HashBiMap.create();
    private final BiMap<class_2960, T> client = HashBiMap.create();
    private final Endec<BiMap<class_2960, T>> mapEndec;
    private BiConsumer<class_2960, T> handleEntry = (location, t) -> {};

    protected ManagedEndecDataLoader(class_2960 id, String type, Endec<T> endec) {
        super(SerializationContext.empty(), id, type, endec);
        this.mapEndec = ManagedEndecDataLoader.biMapEndec(class_2960::toString, class_2960::method_12829, endec);
        ALL_DATA_LOADERS.put(id, this);
        AccessoriesInternals.registerLoader(this, this::setupOps);
    }

    public static <T> ManagedEndecDataLoader<T> of(class_2960 id, String type, Endec<T> endec) {
        return ManagedEndecDataLoader.of(id, type, endec);
    }

    public ManagedEndecDataLoader<T> onEntryAdd(BiConsumer<class_2960, T> value) {
        this.handleEntry = value;
        return this;
    }

    @Nullable
    public static <T> ManagedEndecDataLoader<T> getLoader(class_2960 id) {
        return ALL_DATA_LOADERS.get(id);
    }

    @Override
    protected void handleRawEntry(class_2960 id, T t) {
        this.handleEntry.accept(id, (class_2960)t);
        this.server.put((Object)id, t);
    }

    public Endec<BiMap<class_2960, T>> mapEndec() {
        return this.mapEndec;
    }

    private void handleUnsafeSync(BiMap<class_2960, ?> map) {
        this.client.clear();
        this.client.putAll(map);
        this.onSync();
    }

    protected void onSync() {
    }

    public Map<class_2960, T> getEntries(class_1937 level) {
        return this.getEntries(level.method_8608());
    }

    public Map<class_2960, T> getEntries(boolean isClientSide) {
        return Collections.unmodifiableMap(isClientSide ? this.client : this.server);
    }

    @Nullable
    public T getEntry(class_2960 id, class_1937 level) {
        return this.getEntry(id, level.method_8608());
    }

    @Nullable
    public T getEntry(class_2960 id, boolean isClientSide) {
        return (T)(isClientSide ? this.client : this.server).get((Object)id);
    }

    public class_2960 getId(T t, class_1937 level) {
        return this.getId(t, level.method_8608());
    }

    public class_2960 getId(T t, boolean isClientSide) {
        return (class_2960)(isClientSide ? this.client : this.server).inverse().get(t);
    }

    @ApiStatus.Internal
    private ManagedEndecDataLoader<T> setupOps(class_7225.class_7874 registries) {
        if (registries instanceof class_5350.class_9180) {
            class_5350.class_9180 lookup = (class_5350.class_9180)registries;
            this.context = this.context.withAttributes(new SerializationAttribute.Instance[]{RegistriesAttribute.of((class_5455)((ConfigurableRegistryLookupAccessor)lookup).getRegistryAccess())});
        } else {
            this.context = this.context.withAttributes(new SerializationAttribute.Instance[]{RegistriesAttribute.of((class_5455)((class_5455)registries))});
        }
        return this;
    }

    @ApiStatus.Internal
    protected Map<class_2960, JsonElement> method_20731(class_3300 resourceManager, class_3695 profiler) {
        if (!this.context.hasAttribute((SerializationAttribute)RegistriesAttribute.REGISTRIES)) {
            throw new IllegalStateException("Unable to prepare files as the given Registry access has not been setup on the server! [Id: " + String.valueOf(this.getLoaderId()) + "]");
        }
        return super.method_20731(resourceManager, profiler);
    }

    @ApiStatus.Internal
    private static <K, V> Endec<BiMap<K, V>> biMapEndec(Function<K, String> keyToString, Function<String, K> stringToKey, Endec<V> valueEndec) {
        return Endec.of((ctx, serializer, map) -> {
            try (Serializer.Map mapState = serializer.map(ctx, valueEndec, map.size());){
                map.forEach((k, v) -> mapState.entry((String)keyToString.apply(k), v));
            }
        }, (ctx, deserializer) -> {
            Deserializer.Map mapState = deserializer.map(ctx, valueEndec);
            HashBiMap map = HashBiMap.create((int)mapState.estimatedSize());
            mapState.forEachRemaining(entry -> map.put(stringToKey.apply((String)entry.getKey()), entry.getValue()));
            return map;
        });
    }

    @ApiStatus.Internal
    public static void init(OwoNetChannel channel, Consumer<Consumer<class_1657>> hookRegistration) {
        channel.registerClientboundDeferred(SyncAllLoaderDataPacket.class, SyncAllLoaderDataPacket.ENDEC);
        hookRegistration.accept(player -> {
            List<SyncLoaderDataPacket> packets = ALL_DATA_LOADERS.values().stream().map(dataLoader -> new SyncLoaderDataPacket(dataLoader.id, dataLoader.server)).toList();
            channel.serverHandle(player).send((Record)new SyncAllLoaderDataPacket(packets));
        });
    }

    @ApiStatus.Internal
    public static void initClient(OwoNetChannel channel) {
        channel.registerClientbound(SyncAllLoaderDataPacket.class, SyncAllLoaderDataPacket.ENDEC, SyncAllLoaderDataPacket::handle);
    }

    @ApiStatus.Internal
    private record SyncAllLoaderDataPacket(List<SyncLoaderDataPacket> packets) {
        private static final StructEndec<SyncAllLoaderDataPacket> ENDEC = StructEndecBuilder.of((StructField)SyncLoaderDataPacket.ENDEC.listOf().fieldOf("packets", SyncAllLoaderDataPacket::packets), SyncAllLoaderDataPacket::new);

        private static void handle(SyncAllLoaderDataPacket packet, ClientAccess access) {
            for (SyncLoaderDataPacket innerPacket : packet.packets()) {
                SyncLoaderDataPacket.handle(innerPacket, access);
            }
        }
    }

    @ApiStatus.Internal
    private record SyncLoaderDataPacket(class_2960 id, BiMap<class_2960, Object> data) {
        private static final Map<class_2960, StructEndec<SyncLoaderDataPacket>> CACHED_ENDECS = new HashMap<class_2960, StructEndec<SyncLoaderDataPacket>>();
        private static final StructEndec<SyncLoaderDataPacket> ENDEC = (StructEndec)Endec.dispatched(id -> {
            ManagedEndecDataLoader loader = ManagedEndecDataLoader.getLoader(id);
            if (loader == null) {
                throw new IllegalStateException("Unable to get following Data Loader to handle the given sync packet: " + String.valueOf(id));
            }
            return (Endec)CACHED_ENDECS.computeIfAbsent((class_2960)id, identifier -> StructEndecBuilder.of((StructField)MinecraftEndecs.IDENTIFIER.fieldOf("id", SyncLoaderDataPacket::id), (StructField)loader.mapEndec.fieldOf("data", SyncLoaderDataPacket::data), SyncLoaderDataPacket::new));
        }, SyncLoaderDataPacket::id, (Endec)MinecraftEndecs.IDENTIFIER);

        private static void handle(SyncLoaderDataPacket packet, ClientAccess access) {
            ManagedEndecDataLoader.getLoader(packet.id()).handleUnsafeSync(packet.data());
        }
    }
}

